<?php

$uid = (isset($_GET['UID'])) ? htmlspecialchars($_GET['UID'], ENT_QUOTES) : '';
$mode = (isset($_GET['MODE'])) ? htmlspecialchars($_GET['MODE'], ENT_QUOTES) : '';

$cfg = array(
	'target_log_dir'	=> '../data' // եΤǥ쥯ȥ
,	'target_log_id'		=> $uid
,	'script'			=> $_SERVER['SCRIPT_NAME']
);
$cfg['target_log'] = "{$cfg['target_log_dir']}/{$cfg['target_log_id']}";

mb_language('ja');
mb_internal_encoding('EUC-JP');

switch ($mode)
{
	case 'write':
		if (!file_exists("{$cfg['target_log']}.log")) {
			$cfg['doc_title'] = '顼';
			htmlDoc('ե뤬Ĥޤ');
		}
		$log_data_arr = @file("{$cfg['target_log']}.log");
		$date_name = '';
		$doc = array();
		$basket = array();
		foreach ($log_data_arr as $key => $val) {
			$val = rtrim($val);
			preg_match('/\t(.*?)\-(.*?)\-/', $val, $ym_arr);
			$year_month = $ym_arr[1].$ym_arr[2];
			if ($date_name && $date_name != $year_month) {
				fileExport($date_name, $basket, 0);
				$basket = array();
				$doc[] = "{$cfg['target_log_id']}-{$date_name}.log 񤭽Фޤ";
			}
			$date_name = $year_month;
			$basket[$key] = $val;
		}
		if (fileExport($date_name, $basket, 'last') == 1) {
			$doc[] = "{$cfg['target_log_id']}.log 񤭴ޤ";
		} else {
			$doc[] = "{$cfg['target_log_id']}-{$date_name}.log 񤭽Фޤ";
			$doc[] = "{$cfg['target_log_id']}.log 񤭴ޤ";
		}
		$cfg['doc_title'] = 'ե񤭽Ф';
		htmlDoc($doc);

	default:
		$doc = array();
		if ($handle = @opendir($cfg['target_log_dir'])) {
			while (false !== ($file = readdir($handle))) {
				if (preg_match('/(?<!\-\d{6})\.log$/', $file)) {
					$uid = preg_replace('/\.log$/', '', $file);
					$doc[] = "<a href=\"{$cfg['script']}?UID={$uid}&amp;MODE=write\">{$file}</a>";
				}
			}
			closedir($handle);
		} else {
			$cfg['doc_title'] = '顼';
			htmlDoc('ǥ쥯ȥ꤬Ĥޤ');
		}
		$cfg['doc_title'] = '񤭽Фե';
		htmlDoc($doc);
}

// ݡȽ
function fileExport($date_name, $basket, $flag) {
	global $cfg;
	if (!empty($date_name)) {
		$state = 0;
		$file_name = "{$cfg['target_log']}-{$date_name}.log";
		if ($date_name === date('Ym')) {
			$file_name = "{$cfg['target_log']}.log";
			$state = 1;
		} elseif ($flag === 'last') {
			fileWrite($file_name, $basket);
			$file_name = "{$cfg['target_log']}.log";
			$basket = array();
		}
		fileWrite($file_name, $basket);
	} else {
		$cfg['doc_title'] = '顼';
		htmlDoc('ե񤭽Фޤ');
	}
	return $state;
}

// ե񤭽Ф
function fileWrite($file_name, $basket)
{
	$fp = fopen($file_name, 'w');
	foreach ($basket as $val) {
		fwrite($fp, "{$val}\n");
	}
	fclose($fp);
	return;
}

// HTMLɽ
function htmlDoc($doc)
{
	global $cfg;
	if (is_array($doc)) {
		$prn = "<ul>\n";
		foreach ($doc as $val) {
			$val = mb_convert_encoding($val, 'EUC-JP', 'auto');
			$prn .= "<li>{$val}</li>\n";
		}
		$prn .= "</ul>\n";
	} else {
		$prn = "<p>{$doc}</p>\n";
	}
	echo <<< EOD
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="ja" xml:lang="ja">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=euc-jp" />
<title>ʬ</title>
<meta http-equiv="Content-Style-Type" content="text/css" />
<style type="text/css">
<!--
h1 { font-size: 14px; margin: 20px 0 10px; }
h1 span { font-size: 10px; font-weight: normal; }
p, ul { font-size: 12px; line-height: 1.4em; padding: 0 auto; margin: 0; }
-->
</style>
</head>
<body>
<h1>{$cfg['doc_title']} <span><a href="{$cfg['script']}">ΤϤᤫ</a></span></h1>
{$prn}
</body>
</html>

EOD;
	exit;
}

?>
